import { View, Text, FlatList } from "react-native";
import React, { useEffect } from "react";
import { categoriesStyle } from "./featureCategoriesStyle";
import { useDispatch } from "react-redux";
import { useSelector } from "react-redux";
import { getTopCategory } from "../../../redux/slices/categorys/topCategory";
import FeatureCategorySkeleton from "../../../src/skeletons/screens/home/FeatureCategorySkeleton";
import SingleCategory from "./SingleCategory";

const FeatureCategories = ({ headerText }) => {
    const dispatch = useDispatch();
    const { topCategory, loading } = useSelector((state) => state.topCategory);

    useEffect(() => {
        let isMounted = true;
        if (isMounted && topCategory?.length === 0) {
            dispatch(getTopCategory());
        }
        return () => {
            isMounted = false;
        };
    }, [dispatch]);

    return (
        <View>
            <Text style={categoriesStyle.title}>{headerText}</Text>
            {loading ? (
                <FlatList
                    keyExtractor={(_, i) => "fc" + i}
                    data={[1, 2, 3, 4]}
                    horizontal={true}
                    renderItem={({ item }) => (
                        <FeatureCategorySkeleton item={item} />
                    )}
                    showsHorizontalScrollIndicator={false}
                />
            ) : (
                <>
                    {topCategory?.length > 0 && (
                        <FlatList
                            keyExtractor={(_, i) => "fcs" + i}
                            data={topCategory}
                            horizontal={true}
                            renderItem={({ item, index }) => (
                                <SingleCategory
                                    item={item}
                                    index={index}
                                    topCategory={topCategory}
                                />
                            )}
                            showsHorizontalScrollIndicator={false}
                        />
                    )}
                </>
            )}
        </View>
    );
};

export default FeatureCategories;
